package com.gridnine.xtrip.server.ibecorp.tasks.groovy

import com.gridnine.xtrip.common.gds.model.BaseGdsAccount
import com.gridnine.xtrip.common.model.EntityContainer
import com.gridnine.xtrip.common.model.dict.GdsName
import com.gridnine.xtrip.common.model.entity.EntityStorage
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper
import com.gridnine.xtrip.common.model.gds.GdsAccountIndex
import com.gridnine.xtrip.common.search.SearchCriterion
import com.gridnine.xtrip.common.search.SearchQuery
import com.gridnine.xtrip.common.util.TextUtil

StringBuilder builder = new StringBuilder()

int count = 0

SearchQuery sq = new SearchQuery()
sq.getCriteria().getCriterions()
        .add(SearchCriterion.in(GdsAccountIndex.Property.gds.name(), GdsName.SABRE))

EntityStorage es = EntityStorage.get()

List<GdsAccountIndex> gdsAccountIndexList = es.search(GdsAccountIndex.class, sq).getData()

builder.append("Найдено $gdsAccountIndexList.size $GdsName.SABRE \n")

for (GdsAccountIndex ga : gdsAccountIndexList) {
    EntityContainer<BaseGdsAccount> gdsAccount = es.resolve(ga.getSource())

    if (EntityStorageHelper.nonEmpty(gdsAccount)) {
        BaseGdsAccount entity = gdsAccount.getEntity()
        String primaryPCC = (String) entity.getValue("primaryPCC")
        def value = entity.getValue("primaryPCCRef")
        if (value != null && TextUtil.isBlank(primaryPCC)) {
            builder.append("$entity.gds $entity.name : не задан primaryPcc \n")
            count++
        } else if (value == null) {
            builder.append("$entity.gds $entity.name :  не задан primaryPccRef ")
            if (TextUtil.isBlank(primaryPCC)) {
                builder.append("и primaryPccRef ")
            }
            builder.append(" \n")
        }

    }
}
builder.append("Всего ( $count ) не валидных аккаунтов")
answer.booleanData = !(builder.length() == 0)
answer.textData = builder.toString()